<?php namespace WHITEHALLPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Make_Donation extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'whitehall_make_donation';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Make Donation', 'whitehall' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'whitehall' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'donation_section',
            [
                'label' => esc_html__( 'Donation Section', 'whitehall' ),
            ]
        );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'whitehall' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'whitehall' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'whitehall' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'whitehall' ),
			]
		);			
		$this->add_control(
			'image',
			[
				'label' => __( 'Image', 'whitehall' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
            'country_tab', 
			[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['btn_title' => esc_html__('Monthly', 'whitehall')],
						['btn_title' => esc_html__('Just Once', 'whitehall')]
					],
				'fields' => 
				[
					
					[
						'name' => 'btn_title',
						'label' => esc_html__('Tab Button Title', 'whitehall'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'whitehall')
					],
					[
						'name' => 'contact_donation_form_url',
						'label' => esc_html__('Donate Form Url', 'whitehall'),
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'whitehall')
					],
				],
				'title_field' => '{{btn_title}}',
			 ]
        );
		$this->add_control(
			'bg_image',
			[
				'label' => __( 'BG Image', 'whitehall' ),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'whitehall' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Form Title', 'whitehall' ),
			]
		);
		$this->add_control(
			'form_text',
			[
				'label'       => __( 'Form Text', 'whitehall' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Form Text', 'whitehall' ),
			]
		);
		$this->add_control(
			'contact_form_url',
			[
				'label'       => __( 'Contact Form 7 Url', 'whitehall' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Url', 'whitehall' ),
			]
		);
		$this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
    ?>
	
    <!-- donation-section -->
    <section class="donation-section sec-pad">
        <div class="auto-container">
            <?php if($settings['subtitle'] || $settings['title']) { ?>
            <div class="sec-title">
                <?php if($settings['subtitle']) { ?><h6><i class="flaticon-star"></i><span><?php echo wp_kses($settings['subtitle'], true);?></span></h6><?php } ?>
                <?php if($settings['title']) { ?><h2><?php echo wp_kses($settings['title'], true);?></h2>
                <div class="title-shape"></div><?php } ?>
            </div>
            <?php } ?>
            <div class="row clearfix">
                <div class="col-lg-8 col-md-12 col-sm-12 big-column">
                    <div class="content_block_9">
                        <div class="content-box">
                            <div class="row clearfix">
                                <?php if($settings['image']['id']) { ?>
                                <div class="col-lg-6 col-md-6 col-sm-12 image-column">
                                    <figure class="image-box"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'whitehall'); ?>"></figure>
                                </div>
                                <?php } ?>
                                <div class="col-lg-6 col-md-6 col-sm-12 donation-column">
                                    <div class="donation-box">
                                        <div class="tabs-box">
                                            <div class="tab-btn-box centred">
                                                <ul class="tab-btns tab-buttons clearfix">
                                                    <?php $count = 1; foreach($settings['country_tab'] as $key => $item): ?>
                                                    <li class="tab-btn <?php if($count == 2) echo 'active-btn' ?>" data-tab="#tab-<?php echo esc_attr($count); ?>"><?php echo wp_kses($item['btn_title'], true); ?></li>
                                                    <?php $count++; endforeach; ?>
                                                </ul>
                                            </div>
                                            <div class="tabs-content">
                                                <?php $count = 1; foreach($settings['country_tab'] as $key => $item): ?>
                                                <div class="tab <?php if($count == 2) echo 'active-tab' ?>" id="tab-<?php echo esc_attr($count);?>">
                                                    <div class="donation-form">
                                                        <?php echo do_shortcode($item['contact_donation_form_url'], true);?>
                                                    </div>
                                                </div>
                                                <?php $count++; endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12 col-sm-12 small-column">
                    <div class="content_block_10">
                        <div class="content-box">
                            <?php if($settings['bg_image']['id']) { ?>
                            <figure class="image-layer"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'whitehall'); ?>"></figure>
                            <?php } ?>
							<?php if($settings['form_title'] || $settings['form_text']){ ?>
                            <div class="text">
                                <h3><?php echo wp_kses($settings['form_title'], true);?></h3>
                                <p><?php echo wp_kses($settings['form_text'], true);?></p>
                            </div>
                            <?php } ?>
                            <?php if($settings['contact_form_url']){ ?>
                            <div class="join-form">
                                <?php echo do_shortcode($settings['contact_form_url'], true);?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- donation-section end -->        
                     
        <?php
    }
}
